 ; Ŀ
 ;   Wiz - make a rectangular wipeout entity by entity selection.          
 ;   Wx - make a circular wipeout entity.                                  
 ;   Copyright 2004, 2005, 2007, 2009, 2010 by Rocket Software Ltd.        
 ;   Why is there no processed meat made from fish?                        
 ; 

 ; Ŀ
 ;   Subroutine Deflep - make the Defpoints layer or make it current.      
 ;   Brooks no arguments, calls nothing, returns t or nil.                 
 ; 
 (DEFUN DEFLEP (/ lanam revisp laset)
  (setq lanam "defpoints")
 ; Ŀ
 ;   See if the desired layer is ready to use.                             
 ; 
  (if (setq revisp (tblsearch "layer" lanam))
      (setq laset (layp lanam)))
 ; Ŀ
 ;   Act appropriately.                                                    
 ; 
  (cond ((and revisp (null laset))
         (setvar "clayer" lanam))
        ((null laset)
         (command "-layer" "m" lanam ""))
        (laset
         (prompt (strcat "\n* The " lanam " layer is " (car laset) ". *\n"))))
 (if laset () t))
 ; Ŀ
 ;   Deflep end.                                                           
 ; 

 ; Ŀ
 ;   Not currently called: if used on an entity which is part of a group,  
 ;   copies the group but deletes only the entity, resulting in massive    
 ;   duplication.                                                          
 ;   Unless reverse compatibility is an issue the draworder command may    
 ;   be better.                                                            
 ;   Subroutine Frunz - bring entities to the front of the drawing dbase.  
 ;   Argument: SS, a selection set.                                        
 ;   Returns nothing, Calls nothing, Chews gum.                            
 ; 
 (DEFUN FRUNZ (ss / enam num)
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (command "copy" enam "" "0,0" "0,0")
         (entdel enam)
         (redraw (entlast)))
 (princ))
 ; Ŀ
 ;   Frunz end.                                                            
 ; 

 ; Ŀ
 ;   Layp - see if a layer is off, locked, or frozen.                      
 ;   Takes one argument, a layer name.                                     
 ;   Returns a list of conditions or nil                                   
 ; 
 (DEFUN LAYP (lanam / llist sev col stalst)
  (setq llist (tblsearch "layer" lanam))
  (setq sev (cdr (assoc 70 llist)))
  (setq col (cdr (assoc 62 llist)))
  (if (= (logand sev 1) 1) (setq stalst (list "frozen")))
  (if (= (logand sev 4) 4) (setq stalst (cons "locked" stalst)))
  (if (minusp col) (setq stalst (cons "off" stalst)))
 stalst)
 ; Ŀ
 ;   Layp end.                                                             
 ; 

 ; Ŀ
 ;   Mag - make a randomly named group.                                    
 ;   Argument: Ss, a selection set of stuff to group.                      
 ;   Returns a group name.                                                 
 ; 
 (DEFUN MAG (ss / namm)
 ; Ŀ
 ;   Concoct a group name.                                                 
 ; 
  (setq lup (getvar "luprec"))              ; don't make local
  (setvar "luprec" 8)
  (setq namm (rtos (getvar "date")))        ; get exact time
  (setq namm (strcat "G" (substr namm 9)))
  (setvar "luprec" lup)
 ; Ŀ
 ;   Make the group.                                                       
 ; 
  (command ".group" "" namm "" ss "")
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
 namm)
 ; Ŀ
 ;   Mag end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Ptca - multi-straight-segment pline circle maker.          
 ;   Arguments: Pa, the centre point.                                      
 ;              Radd, the radius.                                          
 ;              Rerp, the number of segments.                              
 ;   Returns the ename of the new entity.                                  
 ; 
 (DEFUN PTCA (pa radd reps / reps pa pa1 pa2 angg)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (command ".pline")
  (repeat reps
         (setq angg (+ angg incr))
         (setq pa2 (polar pa angg radd))
         (command pa2)
         (setq pa1 pa2))
  (command "c")
 (entlast))
 ; Ŀ
 ;   Ptca end.                                                             
 ; 

 ; Ŀ
 ;   WX.                                                                   
 ; 
 (DEFUN C:WX (/ *error* osm snapp ss enam lup)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osm (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq clayer (getvar "clayer"))
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osm)
   (setvar "snapmode" snapp)
   (setvar "clayer" clayer)
   (if lup (setvar "luprec" lup))
   (command ".undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Get stuff not to bring to the front.                                  
 ; 
  (prompt "Select things to not cover: ")
  (setq ss (ssget))
 ; Ŀ
 ;   Get the circle centre point and radius.                               
 ; 
  (setvar "snapmode" snapp)
  (write-line "\nIndicate circle centre and radius: ")
  (command ".circle" pause pause)
  (setq enam (entlast))
  (setq entt (entget enam))
  (setq pa (cdr (assoc 10 entt)))
  (setq rada (cdr (assoc 40 entt)))
  (command ".erase" "l" "")
 ; Ŀ
 ;   Draw the polyline.                                                    
 ; 
  (setq enam (ptca pa rada 32))
 ; Ŀ
 ;   Make the Defpoints layer current.                                     
 ;   Is this a good idea?  And if so then why turn frames off?             
 ;   No - use the layer the first selected entity was on.                  
 ;   Defpoints sometimes works and sometimes doesn't,                      
 ;   apparently depending on the version and phase of the moon.            
 ; 
 ; (deflep)
  (setvar "clayer" (cdr (assoc 8 (entget (ssname ss 0)))))
 ; Ŀ
 ;   Draw a wipeout.                                                       
 ;   Calling Wipeout as a command works in 2005 but only intermittently    
 ;   in 2002, presumably because the lisp routine has been replaced        
 ;   with an internal command.                                             
 ; 
  (if (> (read (substr (getvar "acadver") 1 2)) 14)
      (command ".wipeout" "p" enam "y")
      (progn
           (c:wipeout)
           (command "p" enam "y")))
  (setq enam (entlast))
 ; Ŀ
 ;   Bring everything in the ss to the front.                              
 ; 
  (command "draworder" ss "" "front")
 ; Ŀ
 ;   Group it.                                                             
 ; 
  (ssadd enam ss)
  (mag ss)
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))

 ; Ŀ
 ;   Wiz.                                                                  
 ; 
 (DEFUN C:WIZ (/ *error* clater osm snapp ss lr ll ul ur xmax xmin ymax ymin
                                                                        lup)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osm (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq clayer (getvar "clayer"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osm)
   (setvar "snapmode" snapp)
   (setvar "clayer" clayer)
   (if lup (setvar "luprec" lup))
   (command ".undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Get stuff not to bring to the front.                                  
 ; 
  (prompt "Select things to isolate: ")
  (setq ss (ssget))
 ; Ŀ
 ;   Get the four corner points of the ss.                                 
 ; 
  (if (not pussy) (load "puss"))
  (setq mxlst (pussy ss))

 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq disc (misps))
      (setq disc (getvar "dimscale")))
  (setq disc (* 2 disc))
 ; Ŀ
 ;   Pussy returns: (xmax xmin ymax ymin).                                 
 ; 
  (setq xmax (+ (car mxlst) disc))
  (setq xmin (- (cadr mxlst) disc))
  (setq ymax (+ (caddr mxlst) disc))
  (setq ymin (- (cadddr mxlst) disc))
  (setq ll (list xmin ymin))
  (setq ul (list xmin ymax))
  (setq ur (list xmax ymax))
  (setq lr (list xmax ymin))
 ; Ŀ
 ;   Make the Defpoints layer current.                                     
 ;   Is this a good idea?  And if so then why turn frames off?             
 ;   No.  See the comment for Deflep above.                                
 ; 
 ; (deflep)
  (setvar "clayer" (cdr (assoc 8 (entget (ssname ss 0)))))
 ; Ŀ
 ;   Draw a wipeout.                                                       
 ;   Calling Wipeout as a command works in 2005 but only intermittently    
 ;   in 2002, presumably because the lisp routine has been replaced        
 ;   with an internal coomand.                                             
 ; 
  (if (> (read (substr (getvar "acadver") 1 2)) 14)
      (command ".wipeout" ll ul ur lr "")
      (progn
           (c:wipeout)
           (command ll ul ur lr "")))
  (setq enam (entlast))
 ; Ŀ
 ;   Bring everything in the ss to the front.                              
 ; 
  (command "draworder" ss "" "front")
 ; Ŀ
 ;   Group it.                                                             
 ; 
  (ssadd enam ss)
  (mag ss)
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))

(write-line "c:wiz/c:wx")
(princ)
